//////////////////////////////////////////////////////////////
// the below ALSA types, constants and functions are copied //
// from the pcm.inc file that is a part of fpAlsa           //
//////////////////////////////////////////////////////////////
type
  { Signed frames quantity }
  snd_pcm_sframes_t = cint;

  { PCM handle }
  PPsnd_pcm_t = ^Psnd_pcm_t;
  Psnd_pcm_t = Pointer;

  { PCM stream (direction) }
  snd_pcm_stream_t = cint;

  { PCM sample format }
  snd_pcm_format_t = cint;

  { PCM access type }
  snd_pcm_access_t = cint;

  { Unsigned frames quantity }
  snd_pcm_uframes_t = cuint;

const
    { Playback stream }
    SND_PCM_STREAM_PLAYBACK: snd_pcm_stream_t = 0;

    { 8/16-bit data formats }
//  SND_PCM_FORMAT_S8: snd_pcm_format_t = 0;           // Signed 8 bit
//  SND_PCM_FORMAT_U8: snd_pcm_format_t = 1;           // Unsigned 8 bit
    SND_PCM_FORMAT_S16_LE: snd_pcm_format_t = 2;       // Signed 16 bit Little Endian
//  SND_PCM_FORMAT_S16_BE: snd_pcm_format_t = 3;       // Signed 16 bit Big Endian
//  SND_PCM_FORMAT_U16_LE: snd_pcm_format_t = 4;       // Unsigned 16 bit Little Endian
//  SND_PCM_FORMAT_U16_BE: snd_pcm_format_t = 5;       // Unsigned 16 bit Big Endian

    { snd_pcm_readi/snd_pcm_writei access }
    SND_PCM_ACCESS_RW_INTERLEAVED: snd_pcm_access_t = 3;

// have now switched to "Dynamic Loading" on use, the following variables will hold the dynamically loaded ALSA methods
var snd_pcm_open:      function(pcm: PPsnd_pcm_t; Name: PChar; stream: snd_pcm_stream_t; mode: cint): cint; cdecl;
    snd_pcm_set_params:function(pcm: Psnd_pcm_t; format: snd_pcm_format_t; access: snd_pcm_access_t; channels, rate: cuint; soft_resample: cint; latency: cuint): cint; cdecl;
    snd_pcm_writei:    function(pcm: Psnd_pcm_t; buffer: Pointer; size: snd_pcm_uframes_t): snd_pcm_sframes_t; cdecl;
    snd_pcm_recover:   function(pcm: Psnd_pcm_t; err, silent: cint): cint; cdecl;
    snd_pcm_drain:     function(pcm: Psnd_pcm_t): cint; cdecl;
    snd_pcm_close:     function(pcm: Psnd_pcm_t): cint; cdecl;
    ALSAhandle:TLibHandle={dynlibs.}NilHandle;         // this will hold our handle for the ALSA library


procedure ALSAstartup;
var ALSAname:string='libasound.so.2';
begin
  ALSAhandle:={DynLibs.}SafeLoadLibrary(ALSAname);     // obtain the handle we want
  if ALSAhandle<>{DynLibs.}NilHandle then              // handle was obtained OK
  begin                                                // tie functions to the VARs from above
    Pointer(snd_pcm_open)      :={DynLibs.}GetProcedureAddress(ALSAhandle, PChar('snd_pcm_open'));
    Pointer(snd_pcm_set_params):={DynLibs.}GetProcedureAddress(ALSAhandle, PChar('snd_pcm_set_params'));
    Pointer(snd_pcm_writei)    :={DynLibs.}GetProcedureAddress(ALSAhandle, PChar('snd_pcm_writei'));
    Pointer(snd_pcm_recover)   :={DynLibs.}GetProcedureAddress(ALSAhandle, PChar('snd_pcm_recover'));
    Pointer(snd_pcm_drain)     :={DynLibs.}GetProcedureAddress(ALSAhandle, PChar('snd_pcm_drain'));
    Pointer(snd_pcm_close)     :={DynLibs.}GetProcedureAddress(ALSAhandle, PChar('snd_pcm_close'))
  end
end;


procedure ALSAshutdown;
begin
  if ALSAhandle<>{DynLibs.}NilHandle then
  begin
    {DynLibs.}UnloadLibrary(ALSAhandle);
    ALSAhandle:={DynLibs.}NilHandle
  end
end;


function APlaySound(n:integer):boolean;
const device='default'+#00;                    // name of sound device
var frames:snd_pcm_sframes_t;                  // number of frames written (negative if an error occurred)
       pcm:PPsnd_pcm_t;                        // sound device handle
begin
  result:=false;
  if ALSAhandle={DynLibs.}NilHandle then exit;         // exit if ALSA library not available

  if snd_pcm_open(@pcm, @device[1], SND_PCM_STREAM_PLAYBACK, 0)=0 then
  begin
    if snd_pcm_set_params(pcm, SND_PCM_FORMAT_S16_LE,  // 16-bit signed samples, little endian
                               SND_PCM_ACCESS_RW_INTERLEAVED,
                               1,                      // number of channels
                               22050,                  // sample rate (Hz)
                               1,                      // resampling on/off
                               500000)=0 then          // latency (us)
    begin
      result:=true;
      case n of 1:frames:=snd_pcm_writei(pcm, @plugin, sizeof(plugin) div 2);  // Insert: write whole 800mS at once
                2:frames:=snd_pcm_writei(pcm, @unplug, sizeof(unplug) div 2)   // Remove: write whole 800mS at once
             else frames:=0                                                    // invalid selection, nothing written
      end;  {of case}

      if frames<0 then frames:=snd_pcm_recover(pcm, frames, 0);        // try to recover from any error
      if frames<0 then result:=false;                                  // give up if failed to recover
      snd_pcm_drain(pcm)                                               // drain any remaining samples
    end;
    snd_pcm_close(pcm)
  end
end;

